<?php
/**
 * Plugin Name: T4S Rewriter
 * Description: A plugin for rewriting articles from RSS feeds using AI
 * Version: 1.0.3
 * Author: T4S
 * Text Domain: t4s-rewriter
 */

if (!defined('ABSPATH')) {
    exit;
}

// Autoload Composer dependencies
if (file_exists(__DIR__ . '/vendor/autoload.php')) {
    require_once __DIR__ . '/vendor/autoload.php';
}

// Plugin class autoloading
spl_autoload_register(function ($class) {
    $prefix = 'T4S\\Rewriter\\';
    $base_dir = __DIR__ . '/src/';

    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        return;
    }

    $relative_class = substr($class, $len);
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';

    if (file_exists($file)) {
        require $file;
    }
});

// Plugin constants
define('T4S_REWRITER_VERSION', '1.0.2');
define('T4S_REWRITER_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('T4S_REWRITER_PLUGIN_URL', plugin_dir_url(__FILE__));

// Register activation and deactivation hooks
register_activation_hook(__FILE__, ['\T4S\Rewriter\Plugin', 'activate']);
register_deactivation_hook(__FILE__, ['\T4S\Rewriter\Plugin', 'deactivate']);
register_uninstall_hook(__FILE__, ['\T4S\Rewriter\Plugin', 'uninstall']);

// Initialize the plugin
add_action('plugins_loaded', function() {
    $plugin = \T4S\Rewriter\Plugin::getInstance();
    $plugin->init();
});