<?php

namespace T4S\Rewriter\Job;

class Job {
    private $id;
    private $rss_url;
    private $category_ids;
    private $writing_style;
    private $post_status;
    private $is_active;
    private $articles_processed;
    private $last_run;
    private $created_at;
    private $updated_at;
    private $daily_post_count;
    private $hourly_post_count;
    private $is_ascending;
    private $require_featured_image;

    public function __construct(array $data = []) {
        $this->id = $data['id'] ?? 0;
        $this->rss_url = $data['rss_url'] ?? '';
        $this->category_ids = $data['category_ids'] ?? '[]';
        $this->writing_style = $data['writing_style'] ?? '';
        $this->post_status = $data['post_status'] ?? 'draft';
        $this->is_active = $data['is_active'] ?? 1;
        $this->articles_processed = $data['articles_processed'] ?? 0;
        $this->last_run = $data['last_run'] ?? null;
        $this->created_at = $data['created_at'] ?? current_time('mysql');
        $this->updated_at = $data['updated_at'] ?? current_time('mysql');
        $this->daily_post_count = $data['daily_post_count'] ?? 0;
        $this->hourly_post_count = $data['hourly_post_count'] ?? 0;
        $this->is_ascending = $data['is_ascending'] ?? 0;
        $this->require_featured_image = $data['require_featured_image'] ?? 1;
    }

    public function requireFeaturedImage(): bool {
        return (bool) $this->require_featured_image;
    }

    public function setRequireFeaturedImage(bool $require): void {
        $this->require_featured_image = $require;
    }

    public function getArticlesProcessed(): int {
        return (int) $this->articles_processed;
    }

    public function setArticlesProcessed(int $count): void {
        $this->articles_processed = $count;
    }

    public function getLastRun(): ?string {
        return $this->last_run;
    }

    public function setLastRun(?string $datetime): void {
        $this->last_run = $datetime;
    }

    public function getId(): int {
        return (int) $this->id;
    }

    public function getRssUrl(): string {
        return $this->rss_url;
    }

    public function setRssUrl(string $url): void {
        $this->rss_url = $url;
    }

    public function getCategoryIds(): array {
        return json_decode($this->category_ids, true) ?: [];
    }

    public function setCategoryIds(array $categoryIds): void {
        $this->category_ids = json_encode(array_values($categoryIds));
    }

    // For backward compatibility
    public function getCategoryId(): int {
        $ids = $this->getCategoryIds();
        return !empty($ids) ? (int)$ids[0] : 0;
    }

    // For backward compatibility
    public function setCategoryId(int $categoryId): void {
        $this->setCategoryIds([$categoryId]);
    }

    public function getWritingStyle(): string {
        return $this->writing_style;
    }

    public function setWritingStyle(string $style): void {
        $this->writing_style = $style;
    }

    public function getPostStatus(): string {
        return $this->post_status;
    }

    public function setPostStatus(string $status): void {
        $this->post_status = $status;
    }

    public function isActive(): bool {
        return (bool) $this->is_active;
    }

    public function setActive(bool $active): void {
        $this->is_active = $active;
    }

    public function getDailyPostCount(): int {
        return (int) $this->daily_post_count;
    }

    public function setDailyPostCount(int $count): void {
        $this->daily_post_count = $count;
    }

    public function getHourlyPostCount(): int {
        return (int) $this->hourly_post_count;
    }

    public function setHourlyPostCount(int $count): void {
        $this->hourly_post_count = $count;
    }

    public function isAscending(): bool {
        return (bool) $this->is_ascending;
    }

    public function setAscending(bool $ascending): void {
        $this->is_ascending = $ascending;
    }

    public function getCreatedAt(): string {
        return $this->created_at;
    }

    public function getUpdatedAt(): string {
        return $this->updated_at;
    }

    public function toArray(): array {
        return [
            'id' => $this->id,
            'rss_url' => $this->rss_url,
            'category_ids' => $this->category_ids,
            'writing_style' => $this->writing_style,
            'post_status' => $this->post_status,
            'is_active' => $this->is_active,
            'articles_processed' => $this->articles_processed,
            'last_run' => $this->last_run,
            'daily_post_count' => $this->daily_post_count,
            'hourly_post_count' => $this->hourly_post_count,
            'is_ascending' => $this->is_ascending,
            'require_featured_image' => $this->require_featured_image,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}