<?php

namespace T4S\Rewriter\Cron;

use T4S\Rewriter\Job\JobManager;
use T4S\Rewriter\Util\UrlDecoder;

class RssFeedProcessor
{
    private $jobManager;
    
    public function __construct()
    {
        $this->jobManager = JobManager::getInstance();
    }

    /**
     * Process RSS feeds and store articles
     */
    public function processJobs(array $specific_jobs = null)
    {
        global $wpdb;

        $jobs = $specific_jobs ?? $this->jobManager->getAllJobs(['is_active' => 1]);

        foreach ($jobs as $job) {
            try {
                // Fetch RSS feed
                $rss = fetch_feed($job->getRssUrl());

                if (is_wp_error($rss)) {
                    error_log('T4S Rewriter: Error fetching RSS feed: ' . $rss->get_error_message());
                    continue;
                }

                $items = $rss->get_items();
                // Reverse items order
                $items = array_reverse($items);
                $stored_count = 0;

                foreach ($items as $item) {
                    $url = UrlDecoder::getFinalUrl($item->get_permalink());
                    
                    $url_hash = hash('sha256', $url);

                    // Check if URL has been processed
                    $processed = $wpdb->get_var($wpdb->prepare(
                        "SELECT id FROM {$wpdb->prefix}t4s_rewriter_processed_urls 
                         WHERE url_hash = %s",
                        $url_hash
                    ));

                    if ($processed) {
                        continue;
                    }

                    // Store URL for processing
                    $wpdb->insert(
                        $wpdb->prefix . 't4s_rewriter_processed_urls',
                        [
                            'job_id' => $job->getId(),
                            'url_hash' => $url_hash,
                            'url' => $url,
                            'status' => 'pending',
                            'created_at' => current_time('mysql')
                        ],
                        ['%d', '%s', '%s', '%s', '%s']
                    );

                    $stored_count++;
                }

                // Update job last fetch time
                $wpdb->update(
                    $wpdb->prefix . 't4s_rewriter_jobs',
                    ['last_run' => current_time('mysql')],
                    ['id' => $job->getId()],
                    ['%s'],
                    ['%d']
                );

                error_log("T4S Rewriter: Stored {$stored_count} new articles from job {$job->getId()}");
            } catch (\Exception $e) {
                error_log('T4S Rewriter: Error processing RSS job: ' . $e->getMessage());
                continue;
            }
        }
    }
}