<?php

namespace T4S\Rewriter\Cron;

class DatabaseCleaner
{
    /**
     * Clean up old pending and failed URLs
     * Removes entries older than 7 days
     */
    public function cleanup(): void
    {
        global $wpdb;
        $table = $wpdb->prefix . 't4s_rewriter_processed_urls';
        
        // Calculate timestamp for 7 days ago
        $cutoff_time = date('Y-m-d H:i:s', strtotime('-7 days'));
        
        try {
            // Delete old pending and failed URLs
            $wpdb->query($wpdb->prepare(
                "DELETE FROM $table 
                WHERE status IN ('pending', 'failed') 
                AND created_at < %s",
                $cutoff_time
            ));

            $affected_rows = $wpdb->rows_affected;
            if ($affected_rows > 0) {
                error_log("T4S Rewriter: Cleaned up $affected_rows old pending/failed URLs");
            }
        } catch (\Exception $e) {
            error_log('T4S Rewriter: Error during database cleanup: ' . $e->getMessage());
        }
    }
}