<?php
if (!defined('ABSPATH')) exit;

// Check cron status
$show_cron_warning = false;
$cron_warning_message = '';

if (!defined('DISABLE_WP_CRON')) {
    $show_cron_warning = true;
    $cron_warning_message = '<strong>T4S Rewriter:</strong> The WordPress cron is not running. Please ensure your WordPress cron is properly configured. For more information, see <a href="https://developer.wordpress.org/plugins/cron/hooking-wp-cron-into-the-system-task-scheduler/" target="_blank">Hooking WP-Cron Into the System Task Scheduler</a>.<br/>
    If you are using a managed WordPress hosting provider, you may need to contact support to enable WP-Cron.<br/>
    Please schedule a cron job to run every minute. For example, you can add the following line to your server\'s crontab file:<br/>
    <code>* * * * * /usr/bin/php /path/to/your/wordpress/wp-cron.php > /dev/null 2>&1</code>';
} else if (!wp_next_scheduled('wp_version_check')) {
    $show_cron_warning = true;
    $cron_warning_message = '<strong>T4S Rewriter:</strong> The WordPress cron is not running. This may affect the functionality of the plugin. Please ensure your WordPress cron is properly configured.';
}
?>

<div class="wrap">
    <h1></h1>
    <?php if ($show_cron_warning): ?>
    <div class="notice notice-warning is-dismissible inline">
        <p><?php echo wp_kses_post($cron_warning_message); ?></p>
    </div>
    <?php endif; ?>
    <div class="t4s-welcome-page">
        <div class="t4s-welcome-header">
            <div class="t4s-welcome-brand">
                <span class="dashicons dashicons-admin-site-alt3"></span>
                <h1>Welcome to T4S Rewriter</h1>
            </div>
            <p class="t4s-welcome-subtitle">Transform your content with AI-powered rewriting capabilities</p>
        </div>
        <div class="t4s-welcome-content">
            <div class="t4s-features">
                <div class="t4s-feature-card">
                    <span class="dashicons dashicons-edit"></span>
                    <h3>Smart Content Rewriting</h3>
                    <p>Automatically rewrite your content while maintaining context and meaning using advanced AI technology.</p>
                </div>
                
                <div class="t4s-feature-card">
                    <span class="dashicons dashicons-translation"></span>
                    <h3>Multiple Languages</h3>
                    <p>Support for multiple languages ensures your content reaches a global audience effectively.</p>
                </div>
                
                <div class="t4s-feature-card">
                    <span class="dashicons dashicons-schedule"></span>
                    <h3>Batch Processing</h3>
                    <p>Efficiently process multiple articles with automated job scheduling and management.</p>
                </div>

                <div class="t4s-feature-card">
                    <span class="dashicons dashicons-image-rotate"></span>
                    <h3>Image Handling</h3>
                    <p>Optional automatic downloading and management of images in rewritten content.</p>
                </div>

                <div class="t4s-feature-card">
                    <span class="dashicons dashicons-admin-settings"></span>
                    <h3>Easy Configuration</h3>
                    <p>Simple setup with flexible settings to match your specific content needs.</p>
                </div>

                <div class="t4s-feature-card">
                    <span class="dashicons dashicons-chart-bar"></span>
                    <h3>Usage Tracking</h3>
                    <p>Monitor your API usage and manage your content rewriting quotas effectively.</p>
                </div>
                <div class="t4s-feature-card">
                    <span class="dashicons dashicons-video-alt3"></span>
                    <h3>Video Handling</h3>
                    <p>Automatically detect and insert videos from original content while maintaining proper formatting and context.</p>
                </div>

                <div class="t4s-feature-card">
                    <span class="dashicons dashicons-controls-repeat"></span>
                    <h3>Limit Customization</h3>
                    <p>Flexible control over your content generation with customizable daily and hourly post limits.</p>
                </div>

            </div>

            <div class="t4s-quick-actions">
                <h2>Quick Actions</h2>
                <div class="t4s-action-buttons">
                    <a href="<?php echo esc_url(admin_url('admin.php?page=t4s-rewriter-settings')); ?>" class="t4s-action-button">
                        <span class="dashicons dashicons-admin-settings"></span>
                        Configure Settings
                    </a>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=t4s-rewriter-jobs')); ?>" class="t4s-action-button">
                        <span class="dashicons dashicons-list-view"></span>
                        Manage Jobs
                    </a>
                </div>
            </div>

            <div class="t4s-welcome-footer">
                <h3>Getting Started</h3>
                <ol class="t4s-steps">
                    <li>Configure your API key in the <a href="<?php echo esc_url(admin_url('admin.php?page=t4s-rewriter-settings')); ?>">Settings page</a></li>
                    <li>Select your preferred language and content settings</li>
                    <li>Create your first rewriting job from the <a href="<?php echo esc_url(admin_url('admin.php?page=t4s-rewriter-jobs')); ?>">Jobs page</a></li>
                    <li>Monitor progress and review the rewritten content</li>
                </ol>
            </div>
        </div>
    </div>
</div>