<?php
if (!defined('ABSPATH')) exit;
?>
<div class="wrap t4s-settings-page">
    <h1 class="t4s-page-title"><?php echo esc_html(get_admin_page_title()); ?></h1>
    <?php settings_errors('t4s_rewriter_messages'); ?>

    <div class="t4s-settings-container">
        <form action="options.php" method="post" class="t4s-settings-form">
            <?php
            settings_fields('t4s_rewriter_settings');
            do_settings_sections('t4s-rewriter-settings');
            submit_button('Save Settings', 'primary t4s-submit-button');
            ?>
        </form>

        <?php 
        // Display API status
        $api_key = $settingsManager->getApiKey();
        if ($api_key): 
            try {
                $apiClient->validateApiKey();
                echo '<div class="t4s-api-status t4s-status-success">
                    <span class="dashicons dashicons-yes-alt"></span>
                    <span class="status-text">API connection is working properly</span>
                </div>';
            } catch (\Exception $e) {
                echo '<div class="t4s-api-status t4s-status-error">
                    <span class="dashicons dashicons-warning"></span>
                    <span class="status-text">API connection failed: ' . esc_html($e->getMessage()) . '</span>
                </div>';
            }
        endif;
        ?>
    </div>
</div>