<?php defined('ABSPATH') || exit; ?>

<div class="t4s-jobs-page">
    <div class="t4s-jobs-header">
        <div class="t4s-jobs-stats">
            <div class="t4s-stat-card">
                <span class="dashicons dashicons-list-view"></span>
                <div class="t4s-stat-info">
                    <span class="t4s-stat-value"><?php echo count($jobs); ?></span>
                    <span class="t4s-stat-label">Total Jobs</span>
                </div>
            </div>
            <div class="t4s-stat-card">
                <span class="dashicons dashicons-yes-alt"></span>
                <div class="t4s-stat-info">
                    <span class="t4s-stat-value">
                        <?php 
                        echo array_reduce($jobs, function($count, $job) {
                            return $count + ($job->isActive() ? 1 : 0);
                        }, 0);
                        ?>
                    </span>
                    <span class="t4s-stat-label">Active Jobs</span>
                </div>
            </div>
            <div class="t4s-stat-card">
                <span class="dashicons dashicons-admin-page"></span>
                <div class="t4s-stat-info">
                    <span class="t4s-stat-value">
                        <?php 
                        echo array_reduce($jobs, function($count, $job) {
                            return $count + $job->getArticlesProcessed();
                        }, 0);
                        ?>
                    </span>
                    <span class="t4s-stat-label">Total Articles</span>
                </div>
            </div>
        </div>
    </div>

    <div class="t4s-jobs-table-container">
        <?php if (empty($jobs)): ?>
            <div class="t4s-empty-state">
                <span class="dashicons dashicons-clipboard"></span>
                <h3>No Jobs Found</h3>
                <p>Get started by creating your first rewriting job.</p>
                <a href="<?php echo esc_url(admin_url('admin.php?page=t4s-rewriter-jobs&action=new')); ?>" 
                   class="button button-primary">Create New Job</a>
            </div>
        <?php else: ?>
            <table class="t4s-jobs-table">
                <thead>
                    <tr>
                        <th>RSS URL</th>
                        <th>Categories</th>
                        <th>Writing Style</th>
                        <th>Post Status</th>
                        <th>Daily Limit</th>
                        <th>Hourly Limit</th>
                        <th>Article Order</th>
                        <th>Articles</th>
                        <th>Last Run</th>
                        <th>Status</th>
                        <th class="actions-column">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($jobs as $job): ?>
                        <tr>
                            <td class="rss-url-column">
                                <div class="url-wrapper" title="<?php echo esc_attr($job->getRssUrl()); ?>">
                                    <?php echo esc_html($job->getRssUrl()); ?>
                                </div>
                            </td>
                            <td>
                                <?php 
                                $category_names = array_map(function($cat_id) {
                                    return get_cat_name($cat_id);
                                }, $job->getCategoryIds());
                                echo esc_html(implode(', ', $category_names));
                                ?>
                            </td>
                            <td><?php echo esc_html($job->getWritingStyle()); ?></td>
                            <td><?php echo esc_html($job->getPostStatus()); ?></td>
                            <td>
                                <?php 
                                $daily = $job->getDailyPostCount();
                                echo $daily > 0 ? esc_html($daily) : '<span class="limit-badge">∞</span>';
                                ?>
                            </td>
                            <td>
                                <?php 
                                $hourly = $job->getHourlyPostCount();
                                echo $hourly > 0 ? esc_html($hourly) : '<span class="limit-badge">∞</span>';
                                ?>
                            </td>
                            <td>
                                <span class="order-badge <?php echo $job->isAscending() ? 'asc' : 'desc'; ?>">
                                    <?php echo $job->isAscending() ? '↑ ASC' : '↓ DESC'; ?>
                                </span>
                            </td>
                            <td><span class="articles-count"><?php echo esc_html($job->getArticlesProcessed()); ?></span></td>
                            <td>
                                <?php
                                $last_run = $job->getLastRun();
                                if ($last_run) {
                                    echo '<span class="last-run" title="' . esc_attr($last_run) . '">';
                                    echo esc_html(human_time_diff(strtotime($last_run), current_time('timestamp'))) . ' ago';
                                    echo '</span>';
                                } else {
                                    echo '<span class="never-run">Never</span>';
                                }
                                ?>
                            </td>
                            <td>
                                <span class="status-badge <?php echo $job->isActive() ? 'active' : 'inactive'; ?>">
                                    <?php echo $job->isActive() ? 'Active' : 'Inactive'; ?>
                                </span>
                            </td>
                            <td class="actions-column">
                                <div class="action-buttons">
                                    <a href="<?php echo esc_url(admin_url('admin.php?page=t4s-rewriter-jobs&action=view&job_id=' . $job->getId())); ?>"
                                       class="button action-button view-button" title="View Details">
                                        <span class="dashicons dashicons-visibility"></span>
                                    </a>

                                    <a href="<?php echo esc_url(admin_url('admin.php?page=t4s-rewriter-jobs&action=edit&job_id=' . $job->getId())); ?>"
                                       class="button action-button edit-button" title="Edit Job">
                                        <span class="dashicons dashicons-edit"></span>
                                    </a>

                                    <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" class="inline-form">
                                        <input type="hidden" name="action" value="t4s_fetch_rss_now">
                                        <input type="hidden" name="job_id" value="<?php echo esc_attr($job->getId()); ?>">
                                        <?php wp_nonce_field('t4s_fetch_rss_now'); ?>
                                        <button type="submit" class="button action-button fetch-button" title="Fetch RSS">
                                            <span class="dashicons dashicons-rss"></span>
                                        </button>
                                    </form>

                                    <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" class="inline-form">
                                        <input type="hidden" name="action" value="t4s_process_article_now">
                                        <input type="hidden" name="job_id" value="<?php echo esc_attr($job->getId()); ?>">
                                        <?php wp_nonce_field('t4s_process_article_now'); ?>
                                        <button type="submit" class="button action-button process-button" title="Process Article">
                                            <span class="dashicons dashicons-media-text"></span>
                                        </button>
                                    </form>

                                    <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" class="inline-form">
                                        <input type="hidden" name="action" value="t4s_delete_job">
                                        <input type="hidden" name="job_id" value="<?php echo esc_attr($job->getId()); ?>">
                                        <?php wp_nonce_field('t4s_delete_job'); ?>
                                        <button type="submit" class="button action-button delete-button" 
                                                title="Delete Job"
                                                onclick="return confirm('Are you sure you want to delete this job?');">
                                            <span class="dashicons dashicons-trash"></span>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
</div>