<?php defined('ABSPATH') || exit; ?>

<div class="t4s-job-form-page">
    <div class="t4s-job-form-container">
        <div class="t4s-job-form-header">
            <h2 class="t4s-job-form-title">
                <?php echo $job->getId() ? 'Edit Job' : 'Create New Job'; ?>
            </h2>
            <p class="t4s-job-form-description">
                <?php echo $job->getId() 
                    ? 'Update your RSS rewriting job settings below.' 
                    : 'Configure a new RSS rewriting job by filling out the form below.'; 
                ?>
            </p>
        </div>

        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" class="t4s-job-form">
            <input type="hidden" name="action" 
                   value="<?php echo $job->getId() ? 't4s_update_job' : 't4s_create_job'; ?>">
            <?php if ($job->getId()): ?>
                <input type="hidden" name="job_id" value="<?php echo esc_attr($job->getId()); ?>">
            <?php endif; ?>
            <?php wp_nonce_field($job->getId() ? 't4s_update_job' : 't4s_create_job'); ?>

            <div class="t4s-form-section">
                <div class="t4s-form-field">
                    <label for="rss_url" class="t4s-field-label">RSS URL</label>
                    <div class="t4s-field-input-wrapper">
                        <input type="url" 
                               name="rss_url" 
                               id="rss_url" 
                               class="t4s-field-input"
                               value="<?php echo esc_attr($job->getRssUrl()); ?>" 
                               required>
                        <p class="t4s-field-description">Enter the RSS feed URL for content rewriting</p>
                    </div>
                </div>

                <div class="t4s-form-field">
                    <label for="category_ids" class="t4s-field-label">Categories</label>
                    <div class="t4s-field-input-wrapper">
                        <select name="category_ids[]" id="category_ids" class="t4s-field-input" multiple required>
                            <?php 
                            $selected_categories = $job->getCategoryIds();
                            foreach ($categories as $category): 
                            ?>
                                <option value="<?php echo esc_attr($category->term_id); ?>"
                                        <?php echo in_array($category->term_id, $selected_categories) ? 'selected' : ''; ?>>
                                    <?php echo esc_html($category->name); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                        <p class="t4s-field-description">Choose one or more categories for rewritten content (hold Ctrl/Cmd to select multiple)</p>
                    </div>
                </div>

                <div class="t4s-form-field">
                    <label for="writing_style" class="t4s-field-label">Writing Style</label>
                    <div class="t4s-field-input-wrapper">
                        <select name="writing_style" id="writing_style" class="t4s-field-input" required>
                            <option value="">Select Style</option>
                            <?php foreach ($writing_styles as $value => $label): ?>
                                <option value="<?php echo esc_attr($value); ?>"
                                        <?php selected($job->getWritingStyle(), $value); ?>>
                                    <?php echo esc_html($label); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                        <p class="t4s-field-description">Select the writing style for content rewriting</p>
                    </div>
                </div>

                <div class="t4s-form-field">
                    <label for="post_status" class="t4s-field-label">Post Status</label>
                    <div class="t4s-field-input-wrapper">
                        <select name="post_status" id="post_status" class="t4s-field-input" required>
                            <option value="draft" <?php selected($job->getPostStatus(), 'draft'); ?>>
                                Draft
                            </option>
                            <option value="publish" <?php selected($job->getPostStatus(), 'publish'); ?>>
                                Publish
                            </option>
                        </select>
                        <p class="t4s-field-description">Choose whether to publish posts immediately or save as drafts</p>
                    </div>
                </div>

                <div class="t4s-form-field">
                    <label for="daily_post_count" class="t4s-field-label">Daily Post Limit</label>
                    <div class="t4s-field-input-wrapper">
                        <input type="number" 
                               name="daily_post_count" 
                               id="daily_post_count" 
                               class="t4s-field-input"
                               value="<?php echo esc_attr($job->getDailyPostCount()); ?>" 
                               min="0">
                        <p class="t4s-field-description">Maximum number of posts to complete per day (0 for unlimited)</p>
                    </div>
                </div>

                <div class="t4s-form-field">
                    <label for="hourly_post_count" class="t4s-field-label">Hourly Post Limit</label>
                    <div class="t4s-field-input-wrapper">
                        <input type="number" 
                               name="hourly_post_count" 
                               id="hourly_post_count" 
                               class="t4s-field-input"
                               value="<?php echo esc_attr($job->getHourlyPostCount()); ?>" 
                               min="0">
                        <p class="t4s-field-description">Maximum number of posts to complete per hour (0 for unlimited)</p>
                    </div>
                </div>
                
                <div class="t4s-form-field t4s-checkbox-field">
                    <label class="t4s-field-label">Article Order</label>
                    <div class="t4s-field-input-wrapper">
                        <label class="t4s-toggle-switch">
                            <input type="checkbox" 
                                   name="is_ascending" 
                                   id="is_ascending" 
                                   value="1"
                                   <?php checked($job->isAscending(), true); ?>>
                            <span class="t4s-toggle-slider"></span>
                            <span class="t4s-toggle-label">Ascending Order</span>
                        </label>
                        <p class="t4s-field-description">Process articles in ascending (oldest first) or descending (newest first) order</p>
                    </div>
                </div>

                <div class="t4s-form-field t4s-checkbox-field">
                    <label class="t4s-field-label">Job Status</label>
                    <div class="t4s-field-input-wrapper">
                        <label class="t4s-toggle-switch">
                            <input type="checkbox" 
                                   name="is_active" 
                                   id="is_active" 
                                   value="1"
                                   <?php checked($job->isActive(), true); ?>>
                            <span class="t4s-toggle-slider"></span>
                            <span class="t4s-toggle-label">Active</span>
                        </label>
                        <p class="t4s-field-description">Enable or disable this rewriting job</p>
                    </div>
                </div>

                <div class="t4s-form-field t4s-checkbox-field">
                    <label class="t4s-field-label">Featured Image</label>
                    <div class="t4s-field-input-wrapper">
                        <label class="t4s-toggle-switch">
                            <input type="checkbox"
                                   name="require_featured_image"
                                   id="require_featured_image"
                                   value="1"
                                   <?php checked($job->requireFeaturedImage(), true); ?>>
                            <span class="t4s-toggle-slider"></span>
                            <span class="t4s-toggle-label">Require Featured Image</span>
                        </label>
                        <p class="t4s-field-description">Only post articles with featured images</p>
                    </div>
                </div>
                
            </div>

            <div class="t4s-form-actions">
                <button type="submit" class="button button-primary button-large">
                    <?php echo $job->getId() ? 'Update Job' : 'Create Job'; ?>
                </button>
                <a href="<?php echo esc_url(admin_url('admin.php?page=t4s-rewriter-jobs')); ?>" 
                   class="button button-large">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>