<?php defined('ABSPATH') || exit; ?>

<div class="t4s-job-details-page">
    <div class="t4s-job-details-header">
        <h2>Job Details</h2>
        <div class="t4s-job-actions">
            <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" class="t4s-inline-form">
                <input type="hidden" name="action" value="t4s_fetch_rss_now">
                <input type="hidden" name="job_id" value="<?php echo esc_attr($job->getId()); ?>">
                <?php wp_nonce_field('t4s_fetch_rss_now'); ?>
                <button type="submit" class="button t4s-action-button fetch-button">
                    <span class="dashicons dashicons-rss"></span>
                    Fetch RSS Now
                </button>
            </form>

            <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" class="t4s-inline-form">
                <input type="hidden" name="action" value="t4s_process_article_now">
                <input type="hidden" name="job_id" value="<?php echo esc_attr($job->getId()); ?>">
                <?php wp_nonce_field('t4s_process_article_now'); ?>
                <button type="submit" class="button t4s-action-button process-button">
                    <span class="dashicons dashicons-media-text"></span>
                    Process Next Article
                </button>
            </form>

            <a href="<?php echo esc_url(admin_url('admin.php?page=t4s-rewriter-jobs&action=edit&job_id=' . $job->getId())); ?>" 
               class="button t4s-action-button edit-button">
                <span class="dashicons dashicons-edit"></span>
                Edit Job
            </a>
        </div>
    </div>

    <div class="t4s-job-info-grid">
        <div class="t4s-info-card">
            <span class="dashicons dashicons-rss"></span>
            <div class="t4s-info-content">
                <label>RSS URL</label>
                <div class="t4s-info-value url-value" title="<?php echo esc_attr($job->getRssUrl()); ?>">
                    <?php echo esc_html($job->getRssUrl()); ?>
                </div>
            </div>
        </div>

        <div class="t4s-info-card">
            <span class="dashicons dashicons-category"></span>
            <div class="t4s-info-content">
                <label>Categories</label>
                <div class="t4s-info-value">
                    <?php
                    $category_names = array_map(function($cat_id) {
                        return get_cat_name($cat_id);
                    }, $job->getCategoryIds());
                    echo esc_html(implode(', ', array_filter($category_names)));
                    ?>
                </div>
            </div>
        </div>

        <div class="t4s-info-card">
            <span class="dashicons dashicons-edit"></span>
            <div class="t4s-info-content">
                <label>Writing Style</label>
                <div class="t4s-info-value">
                    <?php echo esc_html($job->getWritingStyle()); ?>
                </div>
            </div>
        </div>

        <div class="t4s-info-card">
            <span class="dashicons dashicons-marker"></span>
            <div class="t4s-info-content">
                <label>Status</label>
                <div class="t4s-info-value">
                    <span class="status-badge <?php echo $job->isActive() ? 'active' : 'inactive'; ?>">
                        <?php echo $job->isActive() ? 'Active' : 'Inactive'; ?>
                    </span>
                </div>
            </div>
        </div>

        <div class="t4s-info-card">
            <span class="dashicons dashicons-calendar"></span>
            <div class="t4s-info-content">
                <label>Daily Post Count</label>
                <div class="t4s-info-value">
                    <?php echo $job->getDailyPostCount() === 0 ? '∞' : esc_html($job->getDailyPostCount()); ?>
                </div>
            </div>
        </div>

        <div class="t4s-info-card">
            <span class="dashicons dashicons-clock"></span>
            <div class="t4s-info-content">
                <label>Hourly Post Count</label>
                <div class="t4s-info-value">
                    <?php echo $job->getHourlyPostCount() === 0 ? '∞' : esc_html($job->getHourlyPostCount()); ?>
                </div>
            </div>
        </div>

        <div class="t4s-info-card">
            <span class="dashicons dashicons-sort"></span>
            <div class="t4s-info-content">
                <label>Processing Order</label>
                <div class="t4s-info-value">
                    <?php echo $job->isAscending() ? 'Ascending' : 'Descending'; ?>
                </div>
            </div>
        </div>

        <div class="t4s-info-card">
            <span class="dashicons dashicons-images-alt2"></span>
            <div class="t4s-info-content">
                <label>Featured Image</label>
                <div class="t4s-info-value">
                    <?php echo $job->requireFeaturedImage() ? 'Required' : 'Optional'; ?>
                </div>
            </div>
        </div>

        <div class="t4s-info-card">
            <span class="dashicons dashicons-media-text"></span>
            <div class="t4s-info-content">
                <label>Articles Processed</label>
                <div class="t4s-info-value">
                    <?php echo esc_html($job->getArticlesProcessed()); ?>
                </div>
            </div>
        </div>

        <div class="t4s-info-card">
            <span class="dashicons dashicons-calendar-alt"></span>
            <div class="t4s-info-content">
                <label>Last Run</label>
                <div class="t4s-info-value">
                    <?php
                    $last_run = $job->getLastRun();
                    if ($last_run) {
                        echo '<span title="' . esc_attr($last_run) . '">' . 
                             esc_html(human_time_diff(strtotime($last_run), current_time('timestamp'))) . ' ago</span>';
                    } else {
                        echo '<span class="never-run">Never</span>';
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>

    <div class="t4s-processed-articles-section">
        <div class="t4s-section-header">
            <h3>Processed Articles</h3>
            <div class="t4s-filter-controls">
                <form method="get" class="t4s-filter-form">
                    <input type="hidden" name="page" value="t4s-rewriter-jobs">
                    <input type="hidden" name="action" value="view">
                    <input type="hidden" name="job_id" value="<?php echo esc_attr($job->getId()); ?>">
                    <select name="status" class="t4s-status-filter">
                        <option value="">All Statuses</option>
                        <?php foreach ($pagination['available_statuses'] as $status): ?>
                            <option value="<?php echo esc_attr($status); ?>" <?php selected($pagination['status_filter'], $status); ?>>
                                <?php echo esc_html(ucfirst($status)); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                    <button type="submit" class="button">Filter</button>
                </form>
                <div class="t4s-items-count">
                    <?php echo sprintf(_n('%s item', '%s items', $pagination['total_items'], 't4s-rewriter'), 
                          number_format_i18n($pagination['total_items'])); ?>
                </div>
            </div>
        </div>

        <div class="t4s-articles-table-container">
            <table class="t4s-articles-table">
                <thead>
                    <tr>
                        <th>Original URL</th>
                        <th>Status</th>
                        <th>Article</th>
                        <th>Processed</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($processed_urls)): ?>
                        <tr>
                            <td colspan="5" class="t4s-no-items">
                                <span class="dashicons dashicons-marker"></span>
                                <p>No articles processed yet.</p>
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($processed_urls as $url): ?>
                            <tr>
                                <td>
                                    <div class="t4s-url-cell">
                                        <a href="<?php echo esc_url($url->url); ?>" 
                                           target="_blank" rel="noopener noreferrer"
                                           title="<?php echo esc_attr($url->url); ?>">
                                            <?php echo esc_html($url->url); ?>
                                        </a>
                                    </div>
                                </td>
                                <td>
                                    <span class="t4s-status-indicator status-<?php echo esc_attr($url->status); ?>">
                                        <?php echo esc_html(ucfirst($url->status)); ?>
                                        <?php if ($url->status === 'failed' && $url->error_message): ?>
                                            <span class="dashicons dashicons-info error-info" 
                                                  title="<?php echo esc_attr($url->error_message); ?>"></span>
                                        <?php endif; ?>
                                    </span>
                                </td>
                                <td>
                                    <?php if ($url->article_id): ?>
                                        <a href="<?php echo get_edit_post_link($url->article_id); ?>" 
                                           class="t4s-article-link">
                                            <?php echo get_the_title($url->article_id); ?>
                                        </a>
                                    <?php else: ?>
                                        <span class="t4s-no-article">-</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if ($url->processed_at): ?>
                                        <span class="t4s-processed-time" 
                                              title="<?php echo esc_attr($url->processed_at); ?>">
                                            <?php echo esc_html(human_time_diff(strtotime($url->processed_at), 
                                                  current_time('timestamp'))); ?> ago
                                        </span>
                                    <?php else: ?>
                                        <span class="t4s-no-time">-</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if ($url->status !== 'completed'): ?>
                                        <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" 
                                              class="t4s-inline-form">
                                            <input type="hidden" name="action" value="t4s_process_specific_article">
                                            <input type="hidden" name="job_id" value="<?php echo esc_attr($job->getId()); ?>">
                                            <input type="hidden" name="article_id" value="<?php echo esc_attr($url->id); ?>">
                                            <?php wp_nonce_field('t4s_process_specific_article'); ?>
                                            <button type="submit" class="button t4s-process-button">
                                                <span class="dashicons dashicons-update"></span>
                                                Process
                                            </button>
                                        </form>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <?php if ($pagination['total_pages'] > 1): ?>
            <div class="t4s-pagination">
                <?php
                // First page
                if ($pagination['current_page'] > 1) {
                    $query_args = ['paged' => 1];
                    if ($pagination['status_filter']) {
                        $query_args['status'] = $pagination['status_filter'];
                    }
                    printf(
                        '<a href="%s" class="t4s-page-button first-page" title="First Page"><span class="dashicons dashicons-controls-skipback"></span></a>',
                        esc_url(add_query_arg($query_args))
                    );

                    $query_args['paged'] = $pagination['current_page'] - 1;
                    printf(
                        '<a href="%s" class="t4s-page-button prev-page" title="Previous Page"><span class="dashicons dashicons-controls-back"></span></a>',
                        esc_url(add_query_arg($query_args))
                    );
                }

                echo '<span class="t4s-page-info">';
                echo sprintf(
                    _x('Page %1$s of %2$s', 'paging'),
                    $pagination['current_page'],
                    $pagination['total_pages']
                );
                echo '</span>';

                if ($pagination['current_page'] < $pagination['total_pages']) {
                    $query_args = ['paged' => $pagination['current_page'] + 1];
                    if ($pagination['status_filter']) {
                        $query_args['status'] = $pagination['status_filter'];
                    }
                    printf(
                        '<a href="%s" class="t4s-page-button next-page" title="Next Page"><span class="dashicons dashicons-controls-forward"></span></a>',
                        esc_url(add_query_arg($query_args))
                    );

                    $query_args['paged'] = $pagination['total_pages'];
                    printf(
                        '<a href="%s" class="t4s-page-button last-page" title="Last Page"><span class="dashicons dashicons-controls-skipforward"></span></a>',
                        esc_url(add_query_arg($query_args))
                    );
                }
                ?>
            </div>
        <?php endif; ?>
    </div>
</div>