<?php

namespace T4S\Rewriter\Admin;

class WelcomePage {
    public function init() {
        add_action('admin_menu', [$this, 'addMenuPage']);
        add_action('admin_enqueue_scripts', [$this, 'enqueueAssets']);
    }

    public function addMenuPage() {
        add_menu_page(
            'T4S Rewriter Welcome', // Page title
            'T4S Rewriter',         // Menu title
            'manage_options',       // Capability
            't4s-rewriter',        // Menu slug
            [$this, 'renderPage'],  // Callback
            'dashicons-admin-site-alt3', // Icon - changed to match welcome page
            30                      // Position
        );
    }

    public function enqueueAssets($hook) {
        // Only load on plugin page
        if ($hook !== 'toplevel_page_t4s-rewriter') {
            return;
        }

        // Enqueue admin styles
        wp_enqueue_style(
            't4s-rewriter-admin',
            plugins_url('/assets/css/admin.css', dirname(dirname(__FILE__))),
            [],
            '1.0.1'
        );

        // Ensure dashicons are loaded
        wp_enqueue_style('dashicons');

        // Enqueue admin scripts
        wp_enqueue_script(
            't4s-rewriter-admin',
            plugins_url('/assets/js/admin.js', dirname(dirname(__FILE__))),
            ['jquery'],
            '1.0.1',
            true
        );
    }

    public function renderPage() {
        if (!current_user_can('manage_options')) {
            return;
        }

        // Include template file
        require_once dirname(__FILE__) . '/templates/welcome-page.php';
    }
}