<?php

namespace T4S\Rewriter\Admin;

use T4S\Rewriter\Job\JobManager;
use T4S\Rewriter\Settings\SettingsManager;
use T4S\Rewriter\Cron\CronHandler;
use T4S\Rewriter\Admin\View\JobsViewController;
use T4S\Rewriter\Admin\Action\JobsActionHandler;

class JobsPage {
    private $jobManager;
    private $settingsManager;
    private $cronHandler;
    private $viewController;
    private $actionHandler;

    public function __construct() {
        $this->jobManager = JobManager::getInstance();
        $this->settingsManager = SettingsManager::getInstance();
        $this->cronHandler = new CronHandler();
        
        $this->viewController = new JobsViewController($this->jobManager, $this->settingsManager);
        $this->actionHandler = new JobsActionHandler($this->jobManager, $this->cronHandler);
    }

    public function init() {
        add_action('admin_menu', [$this, 'addJobsPage']);
        add_action('admin_notices', [$this, 'showAdminNotices']);
        add_action('admin_enqueue_scripts', [$this, 'enqueueAssets']);

        // Initialize the action handler
        $this->actionHandler->init();
    }

    public function enqueueAssets($hook) {
        // Only load on jobs page
        if ('t4s-rewriter_page_t4s-rewriter-jobs' !== $hook) {
            return;
        }

        // Enqueue admin styles
        wp_enqueue_style(
            't4s-rewriter-admin',
            plugins_url('/assets/css/admin.css', dirname(dirname(__FILE__))),
            [],
            '1.0.1'
        );

        // Ensure dashicons are loaded
        wp_enqueue_style('dashicons');
    }

    public function addJobsPage() {
        add_submenu_page(
            't4s-rewriter',
            'Jobs - T4S Rewriter',
            'Jobs',
            'manage_options',
            't4s-rewriter-jobs',
            [$this->viewController, 'renderPage']
        );
    }

    public function showAdminNotices() {
        $notices = get_transient('t4s_rewriter_admin_notices');
        if ($notices) {
            foreach ($notices as $notice) {
                echo '<div class="notice notice-' . ($notice['type'] === 'updated' ? 'success' : 'error') . ' is-dismissible">';
                echo '<p>' . esc_html($notice['message']) . '</p>';
                echo '</div>';
            }
            delete_transient('t4s_rewriter_admin_notices');
        }
    }
}