# T4S Rewriter - User Guide

## Overview

T4S Rewriter is a WordPress plugin that automates content rewriting from RSS feeds. It fetches content from RSS feeds, rewrites it using AI, and publishes it to your WordPress site.

## Installation

### Plugin Installation
1. Upload the plugin to WordPress
2. Activate the plugin
3. Go to T4S Rewriter settings to configure your API key

### WP-Cron Configuration
Since content rewriting is resource-intensive, you need to configure WP-Cron properly:

1. **Disable Default WP-Cron**
   Add this line to your wp-config.php file:
   ```php
   define('DISABLE_WP_CRON', true);
   ```

2. **Set Up External Cron**
   
   #### Using WP-CLI (Recommended)
   If you have WP-CLI installed, this is the most efficient method:
   ```bash
   # Add to your crontab or scheduler
   * * * * * cd /path/to/wordpress && wp cron event run --due-now > /dev/null 2>&1
   ```
   
   Benefits of using WP-CLI:
   - More efficient than calling wp-cron.php via HTTP
   - Direct database access
   - Better error handling and logging
   - No HTTP overhead
   
   #### Using Crontab (Linux/Unix)
   ```bash
   # Open crontab editor
   crontab -e
   
   # Add this line to run WordPress cron every minute
   * * * * * wget -q -O /dev/null "https://your-site.com/wp-cron.php?doing_wp_cron" > /dev/null 2>&1
   # OR using curl
   * * * * * curl -s "https://your-site.com/wp-cron.php?doing_wp_cron" > /dev/null 2>&1
   ```

   #### Using Control Panel Schedulers
   If you're using a hosting control panel:
   1. Go to your control panel's Cron Jobs or Scheduled Tasks section
   2. Create a new cron job
   3. Set it to run every minute
   4. Add the command to call wp-cron.php
   
   Common control panels:
   - **cPanel**: Use "Cron Jobs"
   - **Plesk**: Use "Scheduled Tasks"
   - **DirectAdmin**: Use "Cron Jobs"

   #### Using Windows Task Scheduler
   1. Open Task Scheduler
   2. Create a new task
   3. Set trigger to run every minute
   4. Action: Start a program
   5. Program/script: `curl` or `wget`
   6. Arguments: `"https://your-site.com/wp-cron.php?doing_wp_cron"`

### Verify Cron Setup
1. Check your WordPress debug log for cron-related messages
2. Monitor job processing in the plugin's job details page
3. Verify that articles are being processed regularly
4. For WP-CLI users, you can check scheduled events:
   ```bash
   wp cron event list
   ```

## Plugin Settings

Navigate to T4S Rewriter > Settings to configure the plugin:

### API Configuration
- **API Key**: Enter your T4S Rewriter API key
  - Required for the plugin to function
  - The system will validate your API key
  - A status indicator shows if the connection is working

### Language Settings
Choose from available languages for content rewriting:
- English
- Vietnamese
- Spanish
- French
- German

### Image Settings
- **Download Images**: Toggle automatic image downloading
  - When enabled: Images are downloaded to your media library
  - When disabled: Original image URLs are used

### API Status Monitoring
The settings page displays:
- API connection status
- Connection health indicators
- Error messages if issues are detected

## Creating a Job

1. Navigate to T4S Rewriter > Jobs
2. Click "Add New Job"
3. Configure the following settings:

### Basic Settings
- **RSS URL**: Enter the RSS feed URL to fetch content from
- **Categories**: Select one or more WordPress categories for the rewritten content
- **Writing Style**: Choose from various styles:
  - Auto
  - Professional
  - Casual
  - Academic
  - Creative
  - Technical
  - Journalistic
  - Informative
  - Conversational
- **Post Status**: Choose to publish posts immediately or save as drafts

### Limits & Controls
- **Daily Post Limit**: Maximum posts to process per day (0 = unlimited)
- **Hourly Post Limit**: Maximum posts to process per hour (0 = unlimited)
- **Article Order**: Choose between:
  - Ascending (oldest articles first)
  - Descending (newest articles first)
- **Job Status**: Enable or disable the job
- **Featured Image**: Require or make optional

## Managing Jobs

### View Job Details
The job details page shows:
- All job settings
- Processing statistics
- Last run time
- Processed articles list

### Available Actions
- **Fetch RSS Now**: Manually fetch new articles from RSS
- **Process Next Article**: Manually process the next pending article
- **Edit Job**: Modify job settings
- **Filter Articles**: View articles by status (All/Pending/Completed/Failed)

### Article Status Tracking
Monitor articles with status indicators:
- Pending: Waiting to be processed
- Completed: Successfully rewritten and posted
- Failed: Error during processing (hover for error details)

### Article Management
For each processed article, you can:
- View the original URL
- Access the rewritten post
- See processing time
- Retry failed articles

## Processing Flow

```mermaid
graph LR
    A[RSS Feed] --> B[Fetch Content]
    B --> C[Queue Articles]
    C --> D[Process with AI]
    D --> E[Create Post]
```

1. Plugin fetches content from RSS feed
2. New articles are queued for processing
3. Articles are rewritten according to settings
4. Posts are created in WordPress

## Troubleshooting

### Common Issues
1. **API Issues**
   - Verify your API key is correct
   - Check API connection status in settings
   - Review error messages

2. **RSS Feed Issues**
   - Verify the RSS URL is correct and accessible
   - Check if the feed is valid RSS format

3. **Processing Errors**
   - Review error messages in article list
   - Check daily/hourly limits
   - Verify category settings
   - Check featured image requirements

4. **Cron Issues**
   - Verify wp-cron.php is being called every minute
   - Check server logs for cron execution
   - Ensure proper cron configuration in wp-config.php

### Support
For additional support:
1. Review error messages in the job details
2. Check the WordPress debug log
3. Contact T4S support with specific error details