# T4S Rewriter Documentation

Welcome to the T4S Rewriter plugin documentation. This plugin helps you automate content rewriting from RSS feeds for your WordPress site.

## Features

### Content Rewriting
- AI-powered content rewriting
- Multiple writing styles:
  - Professional
  - Casual
  - Academic
  - Creative
  - Technical
  - Journalistic
  - Informative
  - Conversational
  - Auto mode

### RSS Feed Management
- Automated RSS feed processing
- Support for multiple RSS feeds
- Configurable processing order (ascending/descending)
- Manual feed fetch option

### Language Support
- Multi-language content rewriting:
  - English
  - Vietnamese
  - Spanish
  - French
  - German

### Post Management
- Automatic post creation
- Multiple category assignment
- Configurable post status (Draft/Published)
- Featured image handling
- Tag generation
- Original source URL tracking

### Processing Controls
- Daily post limits
- Hourly post limits
- Job status management (Active/Inactive)
- Featured image requirements toggle

### Media Handling
- Automatic image downloading option
- Media library integration
- Featured image processing
- Original image URL preservation option

### Job Monitoring
- Detailed job statistics
- Processing status tracking
- Error logging and display
- Article processing history
- Last run time tracking

### Performance Features
- WP-Cron integration
- Queue-based processing
- Rate limit handling
- API usage monitoring

## Documentation

Please refer to our [User Guide](user-guide.md) for complete instructions on:

- Installation and setup
- WP-Cron configuration
- Creating and managing rewriting jobs
- Monitoring content processing
- Troubleshooting common issues

## System Requirements

- WordPress 5.0 or higher
- PHP 7.2 or higher
- Valid T4S Rewriter API key
- Properly configured WP-Cron

## Support

If you encounter any issues or need assistance, please check the troubleshooting section in the [User Guide](user-guide.md) or contact our support team.